<?php

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

global $mts_testimonials_admin;

$settings = mts_testimonials_get_settings();

?>
<div class="wrap testimonials">
	<?php 
	$mts_testimonials_admin->messages_html();
	$mts_testimonials_admin->settings_page_tabs_html();
	?>
	<h3><?php _e('WP Testimonial', 'mts-testimonials'); ?></h3>
			
    <form action="" method="post" id="mts-testimonials-general-settings">
        <table class="form-table">
			<tr>
                <td>
				<input type="checkbox" name="moderate_testimonials" id="moderate-testimonials" value="1" <?php checked( $settings['general']['moderate_testimonials'] ); ?> />
				<label for="moderate-testimonials"><?php _e('Moderate testimonials', 'mts-testimonials'); ?></label>
			
				<p class="description"><?php _e('When this option is enabled, then the submitted testimonial status will be set to draft, otherwise it will be published directly.', 'mts-testimonials'); ?></p>
                </td>
            </tr>
            <tr>
                <td>
				<label for="submit-category"><?php _e( 'Submitted testimonial category','mythemeshop' ); ?></label> <br />
				<?php wp_dropdown_categories( Array(
						'orderby'            => 'ID', 
						'order'              => 'ASC',
						'show_count'         => 0,
						'hide_empty'         => 0,
						'hide_if_empty'      => false,
						'echo'               => 1,
						'selected'           => $settings['general']['submit_category'],
						'hierarchical'       => 1, 
						'name'               => 'submit_category',
						'id'                 => 'submit-category',
						'taxonomy'           => 'mts_testimonials_category',
						'show_option_all' 	 => __('No category', 'mts-testimonials')
					) ); ?>
				<p class="description"><?php _e('Automatically add submitted testimonials to the specified category.', 'mts-testimonials'); ?></p>
                </td>
			</tr>
            <tr>
                <td>
				<label for="max-image-size"><?php _e('Max upload size', 'mts-testimonials'); ?></label><br />
				<input type="number" min="0" max="32" name="max_image_size" id="max-image-size" class="small-text" value="<?php echo $settings['general']['max_image_size']; ?>" /> MB
			
				<p class="description"><?php _e('Maximum filesize of the user submitted images.', 'mts-testimonials'); ?></p>
                </td>
            </tr>
            <tr>
                <td>
				<label for="default-image"><?php _e('Default image', 'mts-testimonials'); ?></label><br />
				<input type="text" class="mts-testimonials-url-field" name="default_image" id="default-image" value="<?php echo $settings['general']['default_image']; ?>" /> <input type="button" class="upload-button" value="<?php _e('Browse', 'mts-testimonials'); ?>" /><br />
				<p class="description"><?php _e('Default image to show when it is required but not set.', 'mts-testimonials'); ?></p>
                </td>
            </tr>
			
			
        </table>

		<?php wp_nonce_field( 'mts_testimonial_general_page_action', 'mts_testimonial_general_page_nonce' ); ?>
		
        <p class="submit">
            <input type="submit" name="mts_save_general_settings" id="mts-save-general-settings" class="button button-primary" value="<?php _e('Save settings', 'mts-testimonials'); ?>" />
        </p>
    </form>
    <style type="text/css">#mts-testimonials-general-settings label { font-weight: bold; }</style>
</div>